/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge;

import com.google.inject.Inject;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IPropertyFactory;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.aikar.commands.SpongeCommandManager;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.bstats.sponge.Metrics;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.shared.utils.log.Slf4jLoggerImpl;
import net.skinsrestorer.sponge.SkinApplierSponge;
import net.skinsrestorer.sponge.commands.SkinCommand;
import net.skinsrestorer.sponge.commands.SrCommand;
import net.skinsrestorer.sponge.listeners.LoginListener;
import net.skinsrestorer.sponge.utils.WrapperSponge;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="skinsrestorer", name="SkinsRestorer", version="14.2.3", description="Ability to restore/change skins on servers! (Offline and Online Mode)", url="https://skinsrestorer.net/", authors={"knat", "AlexProgrammerDE", "Blackfire62", "McLive"})
public class SkinsRestorer
implements ISRPlugin {
    private static final boolean BUNGEE_ENABLED = false;
    private final Metrics metrics;
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final SkinApplierSponge skinApplierSponge = new SkinApplierSponge(this);
    private final Path dataFolderPath;
    private final SRLogger srLogger;
    private final MojangAPI mojangAPI;
    private final SkinStorage skinStorage;
    private final SkinsRestorerAPI skinsRestorerAPI;
    private final MineSkinAPI mineSkinAPI;
    private final SkinCommand skinCommand;
    @Inject
    protected Game game;
    private UpdateChecker updateChecker;
    private SpongeCommandManager manager;
    @Inject
    private PluginContainer container;

    @Inject
    public SkinsRestorer(Metrics.Factory metricsFactory, @ConfigDir(sharedRoot=false) Path dataFolderPath, Logger log) {
        this.metrics = metricsFactory.make(2337);
        this.dataFolderPath = dataFolderPath;
        this.srLogger = new SRLogger(new Slf4jLoggerImpl(log));
        this.mojangAPI = new MojangAPI(this.srLogger, this.metricsCounter);
        this.mineSkinAPI = new MineSkinAPI(this.srLogger, this.metricsCounter);
        this.skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
        this.skinsRestorerAPI = new SkinsRestorerSpongeAPI();
        this.skinCommand = new SkinCommand(this);
    }

    @Listener
    public void onInitialize(GameInitializationEvent e) {
        this.srLogger.load(this.getDataFolderPath());
        Path updaterDisabled = this.dataFolderPath.resolve("noupdate.txt");
        if (!Files.exists(updaterDisabled, new LinkOption[0])) {
            this.updateChecker = new UpdateCheckerGitHub(2124, this.getVersion(), this.srLogger, "SkinsRestorerUpdater/Sponge");
            this.checkUpdate();
            Random rn = new Random();
            int delayInt = 60 + rn.nextInt(181);
            Sponge.getScheduler().createTaskBuilder().execute(() -> this.checkUpdate(false)).interval((long)delayInt, TimeUnit.MINUTES).delay((long)delayInt, TimeUnit.MINUTES);
        } else {
            this.srLogger.info("Updater Disabled");
        }
        Config.load(this.dataFolderPath, this.getResource("config.yml"), this.srLogger);
        Locale.load(this.dataFolderPath, this.srLogger);
        if (!this.initStorage()) {
            return;
        }
        this.initCommands();
        Sponge.getScheduler().createAsyncExecutor((Object)this).execute(() -> SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger));
    }

    @Listener
    public void onServerStarted(GameStartedServerEvent event) {
        Sponge.getEventManager().registerListener((Object)this, ClientConnectionEvent.Auth.class, (EventListener)new LoginListener(this));
        this.metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        this.metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        this.metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        this.metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
    }

    private void initCommands() {
        Sponge.getPluginManager().getPlugin("skinsrestorer").ifPresent(pluginContainer -> {
            this.manager = new SpongeCommandManager((PluginContainer)pluginContainer);
            this.prepareACF(this.manager, this.srLogger);
            this.manager.registerCommand(this.skinCommand);
            this.manager.registerCommand(new SrCommand(this));
        });
    }

    private boolean initStorage() {
        if (!SharedMethods.initStorage(this.srLogger, this.skinStorage, this.dataFolderPath)) {
            return false;
        }
        Sponge.getScheduler().createAsyncExecutor((Object)this).execute(this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkUpdate() {
        this.checkUpdate(true);
    }

    private void checkUpdate(final boolean showUpToDate) {
        Sponge.getScheduler().createAsyncExecutor((Object)this).execute(() -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (!showUpToDate) {
                    return;
                }
                SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }
        }));
    }

    @Override
    public String getVersion() {
        return this.container.getVersion().orElse("Unknown");
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.game.getScheduler().createAsyncExecutor((Object)this).execute(runnable);
    }

    @Override
    public Collection<ISRPlayer> getOnlinePlayers() {
        return this.game.getServer().getOnlinePlayers().stream().map(WrapperSponge::wrapPlayer).collect(Collectors.toList());
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    public SkinApplierSponge getSkinApplierSponge() {
        return this.skinApplierSponge;
    }

    @Override
    public Path getDataFolderPath() {
        return this.dataFolderPath;
    }

    @Override
    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    @Override
    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    @Override
    public SkinCommand getSkinCommand() {
        return this.skinCommand;
    }

    public Game getGame() {
        return this.game;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public SpongeCommandManager getManager() {
        return this.manager;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    private class SkinsRestorerSpongeAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerSpongeAPI() {
            super(SkinsRestorer.this.mojangAPI, SkinsRestorer.this.mineSkinAPI, SkinsRestorer.this.skinStorage, new WrapperFactorySponge(), new PropertyFactorySponge());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(Player.class).getName());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String playerName) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(playerName));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty property) {
            SkinsRestorer.this.skinApplierSponge.applySkin(playerWrapper.get(Player.class), property);
        }
    }

    private static class PropertyFactorySponge
    implements IPropertyFactory {
        private PropertyFactorySponge() {
        }

        @Override
        public IProperty createProperty(String name, String value, String signature) {
            return new GenericProperty(name, value, signature);
        }
    }

    private static class WrapperFactorySponge
    extends WrapperFactory {
        private WrapperFactorySponge() {
        }

        @Override
        public ISRPlayer wrapPlayer(Object playerInstance) {
            if (playerInstance instanceof Player) {
                Player player = (Player)playerInstance;
                return WrapperSponge.wrapPlayer(player);
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

